// ============================================================
// Project            :  Carz
// File               :  .\game\gameScripts\player.cs
// Copyright          :  
// Author             :  Leim
// Created on         :  11 kwietnia 2008 17:59
//
// Editor             :  Codeweaver v. 1.2.2685.32755
//
// Description        :  
//                    :  
//                    :  
// ============================================================
function PlayerProfile::createInstance(%name) {
	if(!strlen(%name))
		%name = "default";

	%this = new ScriptObject(PlayerProfile);

	%this.name = %name;
	%this.money = 0;
	%this.moneyString = stripChars(moneyString(playerProfile.money, PlayerProfile.millions), " ,");
	%this.gameid = getRealTime();
	%this.levelAccomplished["10"] = true; 
	%this.levelAccomplished["11"] = false; //Barrens
	%this.levelAccomplished["12"] = false; 
	%this.levelAccomplished["13"] = false; 
	%this.levelAccomplished["21"] = false; //Country
	%this.levelAccomplished["22"] = false; 
	%this.levelAccomplished["23"] = false; 
	%this.levelAccomplished["24"] = false; 
	%this.levelAccomplished["31"] = false; //Suburbs
	%this.levelAccomplished["32"] = false; 
	%this.levelAccomplished["33"] = false; 
	%this.levelAccomplished["34"] = false; 
	%this.levelAccomplished["35"] = false; 
	%this.levelAccomplished["41"] = false; //Sea shore
	%this.levelAccomplished["42"] = false; 
	%this.levelAccomplished["43"] = false; 
	%this.levelAccomplished["44"] = false; 
	%this.levelAccomplished["45"] = false; 
	%this.levelAccomplished["46"] = false; 
	%this.levelAccomplished["51"] = false; //Downtown
	%this.levelAccomplished["52"] = false; 
	%this.levelAccomplished["53"] = false; 
	%this.levelAccomplished["54"] = false; 
	%this.levelAccomplished["55"] = false; 
	%this.levelAccomplished["56"] = false; 
	%this.levelAccomplished["61"] = false; //Hollywood
	%this.levelAccomplished["62"] = false; 
	%this.levelAccomplished["63"] = false; 
	%this.levelAccomplished["64"] = false; 
	%this.levelAccomplished["65"] = false; 
	%this.levelAccomplished["66"] = false; 
	
	%this.hasUpgrade["11"] = "locked"; //Barrens
	%this.hasUpgrade["12"] = "locked"; 
	%this.hasUpgrade["13"] = "locked"; 
	%this.hasUpgrade["21"] = "locked"; //Country
	%this.hasUpgrade["22"] = "locked"; 
	%this.hasUpgrade["23"] = "locked"; 
	%this.hasUpgrade["31"] = "locked"; //Suburbs
	%this.hasUpgrade["32"] = "locked"; 
	%this.hasUpgrade["33"] = "locked"; 
	%this.hasUpgrade["34"] = "locked"; 
	%this.hasUpgrade["41"] = "locked"; //Sea shore
	%this.hasUpgrade["42"] = "locked"; 
	%this.hasUpgrade["43"] = "locked"; 
	%this.hasUpgrade["44"] = "locked"; 
	%this.hasUpgrade["45"] = "locked"; 
	%this.hasUpgrade["51"] = "locked"; //Downtown
	%this.hasUpgrade["52"] = "locked"; 
	%this.hasUpgrade["53"] = "locked"; 
	%this.hasUpgrade["54"] = "locked"; 
	%this.hasUpgrade["55"] = "locked"; 
	%this.hasUpgrade["61"] = "locked"; //Hollywood
	%this.hasUpgrade["62"] = "locked"; 
	%this.hasUpgrade["63"] = "locked"; 
	%this.hasUpgrade["64"] = "locked"; 
	%this.hasUpgrade["65"] = "locked";
	
	return %this;
}

if(!isObject(PlayerProfile))
	PlayerProfile::createInstance();

function savePlayerProfile() {
	if(!isObject(PlayerProfile))
		return;

	PlayerProfile.sendStats();
	
	if(!playerProfile.save(PlayerProfile.name@".sav"))
		warn("Failed saving profile");

	saveConfiguration();
	
	exec(PlayerProfile.name@".sav");

	if(isFile(getPrefsPath()@"/"@PlayerProfile.name@".sav.dso")) //kasujemy tylko jesli udalo sie skompilowac!!
		fileDelete(getPrefsPath()@"/"@PlayerProfile.name@".sav");
}

function loadPlayerProfile(%name) {
	error("Loading" SPC %name);
	
	if(isObject(PlayerProfile))
		PlayerProfile.dirtyStats = true; //na poczatku ustawiamy do wysylamy - slad ze gra jest uruchomiona
	
	
	if(%name !$= $Game::currentPlayer)
		savePlayerProfile();
	
	if(!strlen(%name)) {
		if(!strlen($Game::currentPlayer))
			$Game::currentPlayer = "default";

		%name = $Game::currentPlayer;
	}
	
	%file = %name@".sav";
	if(isFile(%file) || isFile(%file@".dso")) {
		if(isObject(PlayerProfile)) {
			PlayerProfile.delete();
			PlayerProfile.dirtyStats = false; //nie wysylamy przy przeladowaniu
		}
		exec(%file);
		if(isFile(getPrefsPath()@"/"@%file@".dso")) //kasujemy tylko jesli udalo sie skompilowac!!
			fileDelete(getPrefsPath()@"/"@%file);
	}
	else {
		%file = "default.sav";
		if(isFile(%file) || isFile(%file@".dso")) {
			if(isObject(PlayerProfile))
				PlayerProfile.delete();
			exec(%file);
			if(isFile(getPrefsPath()@"/"@%file@".dso")) //kasujemy tylko jesli udalo sie skompilowac!!
				fileDelete(getPrefsPath()@"/"@%file);
		}
	}

	if(!strlen(playerProfile.gameid))
		playerProfile.gameid = getRealTime();
		
	$Game::currentPlayer = PlayerProfile.name;
	PlayerProfile.moneyString = moneyString(PlayerProfile.money, PlayerProfile.millions);
}

function PlayerProfile::addMoney(%this, %money, %millions) {
	%this.money += %money;
	
	while(%this.money > 1000000) {
		%this.money -= 1000000; %this.millions++;
	}
	
	%this.millions += %millions;
	
	%this.moneyString = moneyString(%this.money, %this.millions);
}

function PlayerProfile::getUpgrade(%this, %location, %index) {
	return(%this.hasUpgrade[%location@%index]);
}

function PlayerProfile::getAvailUpgrades(%this, %location) {
	%ret = "";
	for(%i=1; %i<6; %i++) {
		if(strlwr(playerProfile.hasUpgrade[%location@%i]) $= "locked")
			%ret = %ret SPC %location@%i;
	}

	return ltrim(rtrim(%ret));
}

function PlayerProfile::getRandomUpgrades(%this, %location) {
	%upgrades = %this.getAvailUpgrades(%location);
	%count = getWordCount(%upgrades);
	if(%count <2)
		return %upgrades;
	
	%rand1 = getRandom(1, %count);
	%rand2 = %rand1;
	while(%rand2 == %rand1) {
		%rand2 = getRandom(1, %count);
	}
	
	return getWord(%upgrades, (%rand1-1)) SPC getWord(%upgrades, (%rand2-1));
}

function PlayerProfile::setUpgrade(%this, %upgrade, %state) {
	if(!%state)
		%state = "locked";
		
	%this.hasUpgrade[%upgrade] = %state;
}

function PlayerProfile::levelFinished(%this, %level, %primeTime) {
	if(%this.hasLevelFinished(%level) !$= "prime") {
		if(%primeTime)
			%this.levelAccomplished[%level] = "prime";
		else
			%this.levelAccomplished[%level] = "normal";
	}
}

function PlayerProfile::hasLevelFinished(%this, %level) {
	return %this.levelAccomplished[%level];
}

function PlayerProfile::isInPrime(%this, %level) {
	return (%this.hasLevelFinished(%level) $= "prime");
}

function PlayerProfile::isLevelFinished(%this, %level) {
	return ((%this.hasLevelFinished(%level) $= "prime")
			|| (%this.hasLevelFinished(%level) $= "normal"));
}

function PlayerProfile::isLevelSpecial(%this, %location, %level) {
	switch$(%location @ %level) {
		case 24: return true;
		case 35: return true;
		case 46: return true;
		case 56: return true;
		case 66: return true;
		default: return false;
	}
}

function PlayerProfile::getUnlockingLevel(%this, %location, %level) {
	if(%level > 1) return %location @ (%level-1);

	if(%level $= "T" || %level $= "M") { // freeplay : unlocked by special
		switch(%location) {
			case 1: error("THIS SHOULD NEVER HAPPEN, SEE isLevelUnlocked EXCEPTION FOR 1T & 1M");
			case 2: return "24";
			case 3: return "35";
			case 4: return "46";
			case 5: return "56";
			case 6: return "66";
			default: return "locked";
		}
	} else {
		switch(%location) {
			case 1: return ""; // always unlocked
			case 2: return "13";
			case 3: return "23";
			case 4: return "34";
			case 5: return "45";
			case 6: return "55";
			default: return "locked"; // always locked
		}
	}
}

function PlayerProfile::isLevelUnlocked(%this, %location, %level) {
	if(%location == 1 && %level == 1)
		return true;
	
	if(%this.hasLevelFinished(%location @ %level))
		return true;
	
	if(%this.isLevelSpecial(%location, %level)) {
		switch(%location @ %level) {
			case 24:
				return (%this.isInPrime(21) && %this.isInPrime(22) && %this.isInPrime(23));
			case 35:
				return (%this.isInPrime(31) && %this.isInPrime(32) && %this.isInPrime(33) && %this.isInPrime(34));
			case 46:
				return (%this.isInPrime(41) && %this.isInPrime(42) && %this.isInPrime(43)
					&& %this.isInPrime(44) && %this.isInPrime(45));
			case 56:
				return (%this.isInPrime(51) && %this.isInPrime(52) && %this.isInPrime(53)
					&& %this.isInPrime(54) && %this.isInPrime(55));
			case 66:
				return (%this.isInPrime(61) && %this.isInPrime(62) && %this.isInPrime(63)
					&& %this.isInPrime(64) && %this.isInPrime(65));
		}
	} else
	if(%location $= "1" && (%level $= "T" || %level $= "M")) {
		return (%this.isInPrime(11) && %this.isInPrime(12) && %this.isInPrime(13));
	} else {
		%key = %this.hasLevelFinished(%this.getUnlockingLevel(%location, %level));
		return %key $= "normal" || %key $= "prime";
	}
}

function PlayerProfile::checkUnlocked(%this, %currentLevel, %prime) {
	// Hack: Level 65 nie unlockowuje nic wizualnie, bo ma sie odpalic 71
	if(%currentLevel $= "65") return "";
	if(%currentLevel $= "71") %currentLevel = "65";
	
	%location = getSubStr(%currentLevel, 0, 1);
	%level = getSubStr(%currentLevel, 1, 1);
	
	if(%this.isLevelSpecial(%location, %level) && !%this.isLevelFinished(%currentLevel)) {
		%unlocked = %unlocked SPC %location@"T" SPC %location@"M";
	} else {
		if(!%this.isInPrime(%currentLevel) && %prime) {
			%soFarSoGood = true;
			%other = %this.getOtherLevels(%currentLevel);
			for(%i=0; %i<getWordCount(%other); %i++)
				if(!(%soFarSoGood = %this.isInPrime(getWord(%other, %i))))
					break;
			
			if(%soFarSoGood)
				%unlocked = %unlocked SPC %this.getSpecialLevel(%location);
		}
		
		if((%this.getLastLevel(%location) == %currentLevel) && !%this.isLevelFinished(%currentLevel))
			%unlocked = %unlocked SPC %this.getFirstLevel(%location+1);
		
	}
	
	return trim(%unlocked);
}

function PlayerProfile::getOtherLevels(%this, %currentLevel) {
	%location = getSubStr(%currentLevel, 0, 1);
	%level = getSubStr(%currentLevel, 1, 1);
	
	switch(%location) {
		case 1: %levels = "11 12 13";
		case 2: %levels = "21 22 23";
		case 3: %levels = "31 32 33 34";
		case 4: %levels = "41 42 43 44 45";
		case 5: %levels = "51 52 53 54 55";
		case 6: %levels = "61 62 63 64 65";
	}
	
	return removeWord(%levels, (%level-1));
}

/// Maly trick - dla Barrens zwracamy oby freeplay'e
function PlayerProfile::getSpecialLevel(%this, %location) {	
	switch(%location) {
		case 1: %levels = "1T 1M";
		case 2: %levels = "24";
		case 3: %levels = "35";
		case 4: %levels = "46";
		case 5: %levels = "56";
		case 6: %levels = "66";
	}
	return %levels;
}

function PlayerProfile::getLastLevel(%this, %location) {	
	switch(%location) {
		case 1: %level = "13";
		case 2: %level = "23";
		case 3: %level = "34";
		case 4: %level = "45";
		case 5: %level = "55";
		case 6: %level = "65";
	}
	return %level;
}

///Sprawdzanie jaki jest pierwszy level na danej lokacji
///Rozszerzone o sprawdzanie czy taka lokacja w ogole istnieje (lokacja 7, lokacja usunieta z dema itp.)
function PlayerProfile::getFirstLevel(%this, %location) {
	if(!isFile("game/data/levels/location_" @ %location @ ".t2d") && !isFile("game/data/levels/location_" @ %location @ ".t2d.dso"))
		return "";
	
	return %location@"1";
}

/// %statid - identyfikator goal'a, %amount - ilosc, %subtype - typ samochodu
function PlayerProfile::updateStat(%this, %statid, %amount, %subtype) {
	%this.dirtyStats = true;
	if(%statid <= $STATS_TOTAL) {		// Special stat : maximum
		if(%this.stats[%statid] < %amount)
			%this.stats[%statid] = %amount;
	} else {	
		if(strlen(%subtype))
			%this.stats[%statid, %subtype] += %amount;

		%this.stats[%statid] += %amount;
	}

	$BALANCE_AWARDS.callback(%statid, %subtype);
}

function PlayerProfile::getStat(%this, %statid, %subtype) {
	if(strlen(%subtype))
		return %this.stats[%statid, %subtype];
	else
		return %this.stats[%statid];
}

/// %awardid - identyfikator nagrody, %rank - pozycja (1 - zloto, 2 - srebro, 3 - braz)
/// Uwaga! Funkcja nie kontroluje poprawnosci
function PlayerProfile::setAward(%this, %awardid, %rank) {
	//echo("SETTING AWARD" SPC %awardid SPC "FROM" SPC %this.awards[%awardid] SPC "TO" SPC %rank);
	%this.awards[%awardid] = %rank;
}
/// Funkcja zwraca osiagnieta pozycje (0 - brak, 1 - zloto, 2 - srebro, 3 - braz) dla podanego ID
function PlayerProfile::getAward(%this, %awardId) {
	switch$(%awardId) {
		case "Country":
			if(%this.isLevelFinished(24)) return 1; else 
			if(%this.isLevelUnlocked(24)) return 2; else
			if(%this.isLevelFinished(23)) return 3; else
				return 0;
		case "Suburbs":
			if(%this.isLevelFinished(35)) return 1; else 
			if(%this.isLevelUnlocked(35)) return 2; else
			if(%this.isLevelFinished(34)) return 3; else
				return 0;
		case "Seashore":
			if(%this.isLevelFinished(46)) return 1; else 
			if(%this.isLevelUnlocked(46)) return 2; else
			if(%this.isLevelFinished(45)) return 3; else
				return 0;
		case "Downtown":
			if(%this.isLevelFinished(56)) return 1; else 
			if(%this.isLevelUnlocked(56)) return 2; else
			if(%this.isLevelFinished(55)) return 3; else
				return 0;
		case "Hollywood":
			if(%this.isLevelFinished(66)) return 1; else 
			if(%this.isLevelUnlocked(66)) return 2; else
			if(%this.isLevelFinished(65)) return 3; else
				return 0;
		default:
			return %this.awards[%awardId];
	}	
}

function PlayerProfile::getMaxLevel(%this) {
	%levels = "11 12 13 21 22 23 24 31 32 33 34 35 41 42 43 44 45 46 51 52 53 54 55 56 61 62 63 64 65 66";
	for(%i=0; %i<getWordCount(%levels); %i++)
		if(!%this.isLevelFinished(getWord(%levels, %i)))
			return ($maxlevel = getWord(%levels, (%i-1)));
}

///Zbiera statystyki (stats... i levelStats...) i zwraca w postaci "&field=value"
function PlayerProfile::collectStats(%this) {
	%data = "";
	for(%i=0; %i<%this.getDynamicFieldCount(); %i++) {
		%field = %this.getDynamicField(%i);
		if(stricmp(getSubStr(%field, 0, 5), "stats") != 0)
			continue;
		%value = %this.getFieldValue(%field);
		%data = %data@"&"@%field@"="@%value;
	}
	
	return strlwr(%data);
}

function PlayerProfile::sendStats(%this) {
	return;
	
	if(!%this.dirtyStats)
		return;
	
	%name = %this.name;
	%keychain = $licenseKey;
	%gameid = %this.gameid;
	%stats = %this.collectStats();
	sendData("keychain="@%keychain@"&gameid="@%gameid@"&name="@%name@"&stats0_version="@$currentVersion@%stats);
	%this.dirtyStats = false;
}
